﻿[CmdletBinding()]
    Param (
            [Parameter(Mandatory=$true)]
            $Message,
            [Parameter(Mandatory=$false)]
            $ErrorMessage,
            [Parameter(Mandatory=$true)]
            $Component,
            [Parameter(Mandatory=$true)]
            [int]$Type,
            [Parameter(Mandatory=$false)]
            $LogFile
           )

function CMTraceLog {
         [CmdletBinding()]
    Param (
            [Parameter(Mandatory=$false)]
            $Message,
            [Parameter(Mandatory=$false)]
            $ErrorMessage,
            [Parameter(Mandatory=$false)]
            $Component,
            [Parameter(Mandatory=$false)]
            [int]$Type,
            [Parameter(Mandatory=$true)]
            $LogFile
           )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
           $Time = Get-Date -Format "HH:mm:ss.ffffff"
           $Date = Get-Date -Format "MM-dd-yyyy"

           if ($ErrorMessage -ne $null) {$Type = 3}
           if ($Component -eq $null) {$Component = " "}
           if ($Type -eq $null) {$Type = 1}

           $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
           $LogMessage.replace("`0","") | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

if (!($LogFile)){$LogFile = "$env:TEMP\SMSTS_Custom.log"}
CMTraceLog -Message  "$Message" -Type $type -Component $Component -LogFile $LogFile 
Write-Output "CMTraceLog -Message  `"$($Message)`" -Type $($type) -Component $($Component) -LogFile $($LogFile) "
